<?php
require_once 'config.php';
require_once 'functions.php';
require_once 'template.php';

// Load language
$lang = load_language();

// Check if master user is logged in
if (!isset($_SESSION['master_user_id'])) {
    header('Location: login.php');
    exit();
}

$master_user_id = $_SESSION['master_user_id'];
$errors = [];
$success_message = '';

// --- Handle New Email Creation ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['create_email'])) {
    $local_part = trim($_POST['local_part']);
    $password = $_POST['password'];
    $full_email = $local_part . '@randompn.com';

    // Basic validation
    if (empty($local_part) || empty($password)) {
        $errors[] = "Please fill all fields."; // We can add this to lang files later
    } elseif (!preg_match('/^[a-zA-Z0-9._-]+$/', $local_part)) {
        $errors[] = "Invalid characters in email name.";
    } else {
        // Check if email already exists
        $stmt = $pdo->prepare("SELECT id FROM email_accounts WHERE email_address = ?");
        $stmt->execute([$full_email]);
        if ($stmt->fetch()) {
            $errors[] = "This email address is already taken.";
        } else {
            // Insert new email account
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);
            $stmt = $pdo->prepare("INSERT INTO email_accounts (master_user_id, email_address, password) VALUES (?, ?, ?)");
            $stmt->execute([$master_user_id, $full_email, $hashed_password]);
            $success_message = "Email '$full_email' created successfully!";
        }
    }
}

// --- Fetch Existing Email Accounts ---
$stmt = $pdo->prepare("SELECT email_address, created_at FROM email_accounts WHERE master_user_id = ? ORDER BY created_at DESC");
$stmt->execute([$master_user_id]);
$email_accounts = $stmt->fetchAll(PDO::FETCH_ASSOC);


// --- Render The Page ---
render_header("Dashboard", $lang);
?>

<h2>Welcome to your Dashboard!</h2>
<p>Here you can create and manage your email accounts on randompn.com.</p>
<a href="logout.php">Logout</a>
<hr style="margin: 2rem 0;">

<!-- Create New Email Form -->
<h3>Create a new Email Account</h3>
<?php if (!empty($errors)): ?>
    <div class="error-msg"><p><?php echo $errors[0]; ?></p></div>
<?php endif; ?>
<?php if (!empty($success_message)): ?>
    <div class="success-msg"><p><?php echo $success_message; ?></p></div>
<?php endif; ?>

<form action="dashboard.php" method="POST" style="text-align: left;">
    <div style="display: flex; align-items: center; margin-bottom: 1rem;">
        <input type="text" name="local_part" placeholder="e.g., ahmedzaxo" style="flex-grow: 1;" required>
        <span style="margin: 0 10px;">@randompn.com</span>
    </div>
    <input type="password" name="password" placeholder="Choose a strong password for this email" required>
    <button type="submit" name="create_email" class="button">Create Email</button>
</form>

<hr style="margin: 2rem 0;">

<!-- List of Existing Emails -->
<h3>Your Email Accounts</h3>
<?php if (empty($email_accounts)): ?>
    <p>You haven't created any email accounts yet.</p>
<?php else: ?>
    <table style="width: 100%; text-align: left;">
        <thead>
            <tr>
                <th>Email Address</th>
                <th>Created On</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($email_accounts as $account): ?>
                <tr>
                    <td><?php echo htmlspecialchars($account['email_address']); ?></td>
                    <td><?php echo date('Y-m-d', strtotime($account['created_at'])); ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php endif; ?>


<?php
render_footer($lang);
?>
