<?php
// This file requires config.php to be included first
if (!defined('SITE_URL')) {
    die('Config file not loaded.');
}

// --- PHPMailer ---
// Include the PHPMailer library files
require __DIR__ . '/PHPMailer-master/src/Exception.php';
require __DIR__ . '/PHPMailer-master/src/PHPMailer.php';
require __DIR__ . '/PHPMailer-master/src/SMTP.php';

// Use the PHPMailer classes
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// --- LANGUAGE FUNCTION ---
function load_language() {
    $default_lang = 'en'; // Default language is English
    $available_langs = ['en', 'ku_badini', 'ku_sorani', 'ar', 'tr'];

    // 1. Check for language change via GET parameter
    if (isset($_GET['lang']) && in_array($_GET['lang'], $available_langs)) {
        $_SESSION['lang'] = $_GET['lang'];
        // Redirect to remove the lang parameter from URL
        $uri_parts = explode('?', $_SERVER['REQUEST_URI'], 2);
        header('Location: ' . $uri_parts[0]);
        exit();
    }

    // 2. Use language from session if available
    $current_lang_code = isset($_SESSION['lang']) && in_array($_SESSION['lang'], $available_langs)
        ? $_SESSION['lang']
        : $default_lang;

    // 3. Load the language file
    $lang_file = __DIR__ . '/languages/' . $current_lang_code . '.php';

    if (file_exists($lang_file)) {
        require($lang_file);
        $lang['code'] = $current_lang_code; // Add lang code for HTML dir
        return $lang; // Return the $lang array
    } else {
        // Fallback to default language if file not found
        require(__DIR__ . '/languages/' . $default_lang . '.php');
        $lang['code'] = $default_lang;
        return $lang;
    }
}

// --- EMAIL SENDING FUNCTION (REAL IMPLEMENTATION) ---
function send_email($to, $subject, $body) {
    $mail = new PHPMailer(true);

    try {
        //Server settings
        $mail->isSMTP();
        $mail->Host       = MAIL_HOST;
        $mail->SMTPAuth   = true;
        $mail->Username   = MAIL_USERNAME;
        $mail->Password   = MAIL_PASSWORD;
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port       = MAIL_PORT;
        $mail->CharSet    = 'UTF-8';

        //Recipients
        $mail->setFrom(MAIL_FROM_ADDRESS, MAIL_FROM_NAME);
        $mail->addAddress($to);

        //Content
        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body    = $body;
        $mail->AltBody = strip_tags($body);

        $mail->send();
        return true;
    } catch (Exception $e) {
        // You can log the error for debugging
        // error_log("Message could not be sent. Mailer Error: {$mail->ErrorInfo}");
        return false;
    }
}
