<?php
require_once 'config.php';
require_once 'functions.php';
require_once 'template.php';

// Load language
$lang = load_language();

if (!isset($_SESSION['email_account_id'])) {
    header('Location: login.php');
    exit();
}

$email_account_id = $_SESSION['email_account_id'];
$stmt = $pdo->prepare("SELECT email_address FROM email_accounts WHERE id = ?");
$stmt->execute([$email_account_id]);
$account = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$account) {
    header('Location: logout.php');
    exit();
}

$current_virtual_email = $account['email_address'];
$emails = [];
$error_message = '';

try {
    $mailbox = "{" . IMAP_HOST . ":" . IMAP_PORT . "/imap/ssl/novalidate-cert}INBOX";
    $inbox = imap_open($mailbox, IMAP_USER, IMAP_PASS);

    if ($inbox) {
        $search_criteria = 'TO "' . $current_virtual_email . '"';
        $email_numbers = imap_search($inbox, $search_criteria);

        if ($email_numbers) {
            rsort($email_numbers);
            foreach ($email_numbers as $email_number) {
                $overview = imap_fetch_overview($inbox, $email_number, 0);
                
                // --- NEW CODE TO CLEAN UP THE SUBJECT AND FROM ---
                $subject = isset($overview[0]->subject) ? imap_utf8($overview[0]->subject) : 'No Subject';
                $from = isset($overview[0]->from) ? imap_utf8($overview[0]->from) : 'Unknown Sender';
                // --- END OF NEW CODE ---

                // Fetch both plain text and HTML parts
                $structure = imap_fetchstructure($inbox, $email_number);
                $body = '';

                if (isset($structure->parts) && is_array($structure->parts)) {
                    // Look for plain text version first
                    foreach ($structure->parts as $part_num => $part) {
                        if ($part->subtype == 'PLAIN') {
                            $body = imap_fetchbody($inbox, $email_number, $part_num + 1);
                            if ($part->encoding == 3) { // Base64
                                $body = base64_decode($body);
                            } elseif ($part->encoding == 4) { // Quoted-Printable
                                $body = quoted_printable_decode($body);
                            }
                            break; // Found plain text, no need to look further
                        }
                    }
                    // If no plain text, look for HTML version
                    if ($body == '') {
                         foreach ($structure->parts as $part_num => $part) {
                            if ($part->subtype == 'HTML') {
                                $body = imap_fetchbody($inbox, $email_number, $part_num + 1);
                                if ($part->encoding == 3) {
                                    $body = base64_decode($body);
                                } elseif ($part->encoding == 4) {
                                    $body = quoted_printable_decode($body);
                                }
                                $body = strip_tags($body); // Remove HTML tags to show only text
                                break;
                            }
                        }
                    }
                }
                
                // If still no body, try fetching the main body part 1
                if ($body == '') {
                    $body = imap_fetchbody($inbox, $email_number, 1);
                    $body = quoted_printable_decode($body);
                }


                $emails[] = [
                    'from' => htmlspecialchars($from),
                    'subject' => htmlspecialchars($subject),
                    'date' => date('Y-m-d H:i', strtotime($overview[0]->date)),
                    'body' => nl2br(htmlspecialchars($body))
                ];
            }
        }
        imap_close($inbox);
    } else {
        $error_message = "Could not connect. IMAP Error: " . imap_last_error();
    }
} catch (Exception $e) {
    $error_message = "An error occurred: " . $e->getMessage();
}

render_header("Inbox", $lang);
?>

<h2>Inbox for: <?php echo htmlspecialchars($current_virtual_email); ?></h2>
<a href="logout.php">Logout</a>
<hr>

<?php if ($error_message): ?>
    <div class="error-msg"><p><?php echo $error_message; ?></p></div>
<?php endif; ?>

<?php if (empty($emails) && !$error_message): ?>
    <p>Your inbox is empty.</p>
<?php else: ?>
    <div class="email-list">
        <?php foreach ($emails as $email): ?>
            <div class="email-item">
                <h3><?php echo $email['subject']; ?></h3>
                <p><strong>From:</strong> <?php echo $email['from']; ?></p>
                <p><strong>Date:</strong> <?php echo $email['date']; ?></p>
                <div class="email-body">
                    <?php echo $email['body']; ?>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
<?php endif; ?>

<style>
    .email-list .email-item { border: 1px solid #ccc; padding: 15px; margin-bottom: 15px; border-radius: 5px; }
    .email-list .email-item h3 { margin-top: 0; }
    .email-list .email-body { background-color: #f9f9f9; border: 1px solid #eee; padding: 10px; margin-top: 10px; max-height: 200px; overflow-y: auto; }
</style>

<?php
render_footer($lang);
?>
