<?php
require_once 'config.php';
require_once 'functions.php';
require_once 'template.php';

// Load language
$lang = load_language();

$errors = [];

// If user is already logged in, redirect to dashboard
if (isset($_SESSION['master_user_id']) || isset($_SESSION['email_account_id'])) {
    if(isset($_SESSION['master_user_id'])) header('Location: dashboard.php');
    if(isset($_SESSION['email_account_id'])) header('Location: inbox.php'); // We will create inbox.php later
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';

    if (empty($email) || empty($password)) {
        $errors[] = $lang['login_failed'];
    } else {
        // Check if it's a master account login (using Gmail)
        // -- OLD CODE: if (str_ends_with($email, '@gmail.com')) {
        // -- NEW CODE:
        if (substr($email, -10) === '@gmail.com') {
            $stmt = $pdo->prepare("SELECT id, password, is_active FROM master_users WHERE master_email = ?");
            $stmt->execute([$email]);
            $user = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($user && $user['is_active'] && password_verify($password, $user['password'])) {
                // Master user logged in successfully
                $_SESSION['master_user_id'] = $user['id'];
                header('Location: dashboard.php'); // Redirect to master dashboard
                exit();
            } else {
                $errors[] = $lang['login_failed'];
            }
        }
        // Check if it's a sub-account login (using @randompn.com)
        // -- OLD CODE: elseif (str_ends_with($email, '@randompn.com')) {
        // -- NEW CODE:
        elseif (substr($email, -14) === '@randompn.com') {
            $stmt = $pdo->prepare("SELECT id, password FROM email_accounts WHERE email_address = ?");
            $stmt->execute([$email]);
            $account = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($account && password_verify($password, $account['password'])) {
                // Sub-account logged in successfully
                $_SESSION['email_account_id'] = $account['id'];
                header('Location: inbox.php'); // Redirect to inbox
                exit();
            } else {
                $errors[] = $lang['login_failed'];
            }
        } else {
            $errors[] = $lang['login_failed'];
        }
    }
}

// --- Render The Page ---
render_header($lang['login_title'], $lang);
?>

<form action="login.php" method="POST">
    <h2><?php echo $lang['login_title']; ?></h2>

    <?php if (!empty($errors)): ?>
        <div class="error-msg">
            <p><?php echo $errors[0]; ?></p>
        </div>
    <?php endif; ?>

    <input type="email" name="email" placeholder="Gmail or @randompn.com email" required>
    <input type="password" name="password" placeholder="<?php echo $lang['password']; ?>" required>

    <button type="submit" class="button"><?php echo $lang['login_button']; ?></button>
</form>

<div style="margin-top: 1rem; text-align: center;">
    <a href="signup.php" class="button-link"><?php echo $lang['create_account_link']; ?></a>
    <br><br>
    <a href="forgot-password.php" class="button-link"><?php echo $lang['forgot_password_link']; ?></a>
</div>

<?php
render_footer($lang);
?>
