<?php
require_once 'config.php';
require_once 'functions.php';
require_once 'template.php';

// Load language
$lang = load_language();

$errors = [];
$success_message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // --- Data Validation ---
    $first_name = trim($_POST['first_name'] ?? '');
    $last_name = trim($_POST['last_name'] ?? '');
    $master_email = trim($_POST['master_email'] ?? '');
    $password = $_POST['password'] ?? '';
    $re_password = $_POST['re_password'] ?? '';
    $birth_date = !empty($_POST['year']) && !empty($_POST['month']) && !empty($_POST['day'])
        ? "{$_POST['year']}-{$_POST['month']}-{$_POST['day']}"
        : '';
    $gender = $_POST['gender'] ?? '';

    if ($password !== $re_password) {
        $errors[] = $lang['passwords_do_not_match'];
    }
    // -- OLD CODE: if (!filter_var($master_email, FILTER_VALIDATE_EMAIL) || !str_ends_with($master_email, '@gmail.com')) {
    // -- NEW CODE (compatible with older PHP):
    if (!filter_var($master_email, FILTER_VALIDATE_EMAIL) || substr($master_email, -10) !== '@gmail.com') {
        $errors[] = $lang['invalid_email_format'];
    }
    // Check if email already exists
    $stmt = $pdo->prepare("SELECT id FROM master_users WHERE master_email = ?");
    $stmt->execute([$master_email]);
    if ($stmt->fetch()) {
        $errors[] = $lang['email_already_exists'];
    }

    if (empty($errors)) {
        // --- All good, proceed to insert ---
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);
        $verification_code = rand(100000, 999999);

        try {
            $stmt = $pdo->prepare(
                "INSERT INTO master_users (first_name, last_name, master_email, password, birth_date, gender, verification_code, is_active)
                 VALUES (?, ?, ?, ?, ?, ?, ?, 0)"
            );
            $stmt->execute([$first_name, $last_name, $master_email, $hashed_password, $birth_date, $gender, $verification_code]);

            // --- Send Verification Email ---
            $subject = SITE_NAME . " - " . $lang['verification_title'];
            $body = $lang['verification_instructions'] . "<br><h1>" . $verification_code . "</h1>";
            send_email($master_email, $subject, $body);

            // Redirect to verification page
            $_SESSION['verification_email'] = $master_email;
            header('Location: verify.php');
            exit();

        } catch (PDOException $e) {
            $errors[] = "Database error: " . $e->getMessage();
        }
    }
}

// --- Render The Page ---
render_header($lang['signup_title'], $lang);
?>

<form action="signup.php" method="POST">
    <h2><?php echo $lang['signup_title']; ?></h2>
    <p><small><?php echo $lang['signup_subtitle']; ?></small></p>

    <?php if (!empty($errors)): ?>
        <div class="error-msg">
            <?php foreach ($errors as $error): ?>
                <p><?php echo $error; ?></p>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>

    <input type="text" name="first_name" placeholder="<?php echo $lang['first_name']; ?>" required>
    <input type="text" name="last_name" placeholder="<?php echo $lang['last_name']; ?>" required>
    <input type="email" name="master_email" placeholder="<?php echo $lang['gmail_address']; ?>" required>
    <input type="password" name="password" placeholder="<?php echo $lang['password']; ?>" required>
    <input type="password" name="re_password" placeholder="<?php echo $lang['re_password']; ?>" required>

    <!-- Date of Birth -->
    <div style="display: flex; justify-content: space-between; margin-bottom: 1rem;">
        <input type="number" name="day" placeholder="<?php echo $lang['day']; ?>" min="1" max="31" style="width: 30%;" required>
        <input type="number" name="month" placeholder="<?php echo $lang['month']; ?>" min="1" max="12" style="width: 30%;" required>
        <input type="number" name="year" placeholder="<?php echo $lang['year']; ?>" min="1920" max="<?php echo date('Y') - 10; ?>" style="width: 30%;" required>
    </div>

    <!-- Gender -->
    <select name="gender" required>
        <option value="" disabled selected><?php echo $lang['gender']; ?></option>
        <option value="male"><?php echo $lang['male']; ?></option>
        <option value="female"><?php echo $lang['female']; ?></option>
    </select>

    <button type="submit" class="button"><?php echo $lang['signup_button']; ?></button>
</form>
<a href="login.php"><?php echo $lang['login_title']; ?></a>

<?php
render_footer($lang);
?>
