<?php
// This file contains functions to render the header and footer
// It requires functions.php to be included first

function render_header($title, $lang) {
    ?>
    <!DOCTYPE html>
    <html lang="<?php echo substr($lang['code'] ?? 'en', 0, 2); ?>" dir="<?php echo ($lang['code'] ?? 'en') == 'ar' ? 'rtl' : 'ltr'; ?>">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title><?php echo htmlspecialchars($title); ?> - <?php echo SITE_NAME; ?></title>
        <style>
            body { font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif; background-color: #f0f2f5; display: flex; justify-content: center; align-items: center; min-height: 100vh; margin: 0; }
            .container { background-color: #fff; padding: 2rem; border-radius: 8px; box-shadow: 0 4px 12px rgba(0,0,0,0.1); width: 100%; max-width: 400px; text-align: center; }
            .logo { font-size: 2.5rem; font-weight: bold; margin-bottom: 1.5rem; }
            input[type="text"], input[type="email"], input[type="password"], select { width: calc(100% - 20px); padding: 10px; margin-bottom: 1rem; border: 1px solid #ddd; border-radius: 6px; }
            .button { background-color: #28a745; color: white; padding: 12px; border: none; border-radius: 6px; cursor: pointer; width: 100%; font-size: 1rem; font-weight: bold; text-decoration: none; display: inline-block; margin-bottom: 0.5rem; }
            .button-secondary { background-color: #6c757d; }
            .button-link { background: none; border: none; color: #007bff; cursor: pointer; padding: 0; font-size: 0.9rem; }
            .lang-switcher { margin-top: 2rem; }
            .lang-switcher a { margin: 0 5px; text-decoration: none; }
            .error-msg { color: #dc3545; background-color: #f8d7da; border: 1px solid #f5c6cb; padding: 10px; border-radius: 5px; margin-bottom: 1rem; }
            .success-msg { color: #155724; background-color: #d4edda; border: 1px solid #c3e6cb; padding: 10px; border-radius: 5px; margin-bottom: 1rem; }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="logo">Lito Group</div>
    <?php
}

function render_footer($lang) {
    ?>
            <div class="lang-switcher">
                <a href="?lang=en" title="English">🇬🇧</a>
                <a href="?lang=ku_badini" title="کوردی بادینی">🏳️</a>
                <a href="?lang=ku_sorani" title="کوردی سۆرانی">🏳️</a>
                <a href="?lang=ar" title="العربية">🇸🇦</a>
                <a href="?lang=tr" title="Türkçe">🇹🇷</a>
            </div>
        </div>
    </body>
    </html>
    <?php
}
?>
