<?php
require_once 'config.php';
require_once 'functions.php';
require_once 'template.php';

// Load language
$lang = load_language();

// Redirect if the user hasn't been through the signup page
if (!isset($_SESSION['verification_email'])) {
    header('Location: signup.php');
    exit();
}

$errors = [];
$success_message = '';
$verification_email = $_SESSION['verification_email'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $code = trim($_POST['verification_code'] ?? '');

    if (empty($code)) {
        $errors[] = $lang['invalid_verification_code'];
    } else {
        // Check the code in the database
        $stmt = $pdo->prepare("SELECT id FROM master_users WHERE master_email = ? AND verification_code = ? AND is_active = 0");
        $stmt->execute([$verification_email, $code]);
        $user = $stmt->fetch();

        if ($user) {
            // Code is correct, activate the account
            $update_stmt = $pdo->prepare("UPDATE master_users SET is_active = 1, verification_code = NULL WHERE id = ?");
            $update_stmt->execute([$user['id']]);

            // Unset the session and show success message
            unset($_SESSION['verification_email']);
            $success_message = $lang['account_activated_message'];
            // Redirect to login page after a few seconds
            header("refresh:3;url=login.php");

        } else {
            $errors[] = $lang['invalid_verification_code'];
        }
    }
}

// --- Render The Page ---
render_header($lang['verification_title'], $lang);
?>

<h2><?php echo $lang['verification_title']; ?></h2>
<p><?php echo $lang['verification_instructions']; ?></p>

<?php if (!empty($errors)): ?>
    <div class="error-msg">
        <?php foreach ($errors as $error): ?>
            <p><?php echo $error; ?></p>
        <?php endforeach; ?>
    </div>
<?php endif; ?>

<?php if (!empty($success_message)): ?>
    <div class="success-msg">
        <p><?php echo $success_message; ?></p>
    </div>
<?php else: ?>
    <form action="verify.php" method="POST">
        <input type="text" name="verification_code" placeholder="<?php echo $lang['verification_code']; ?>" required>
        <button type="submit" class="button"><?php echo $lang['verify_button']; ?></button>
    </form>
<?php endif; ?>

<?php
render_footer($lang);
?>
